<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) exit();

$client_id = $_GET['client_id'];
$client = $conn->query("SELECT name FROM clients WHERE id = $client_id")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>New Ledger Entry</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background: #f8f9fc; padding: 50px; }
        .form-card { background: #fff; max-width: 500px; margin: auto; padding: 30px; border-radius: 15px; box-shadow: 0 10px 25px rgba(0,0,0,0.05); }
        input, select, textarea { width: 100%; padding: 12px; margin: 10px 0; border: 1px solid #ddd; border-radius: 10px; box-sizing: border-box; }
        .btn { background: #4e73df; color: white; padding: 15px; border: none; width: 100%; border-radius: 10px; font-weight: 600; cursor: pointer; }
        .type-selector { display: flex; gap: 10px; margin-bottom: 20px; }
        .type-btn { flex: 1; text-align: center; padding: 10px; border: 2px solid #ddd; border-radius: 8px; cursor: pointer; font-weight: 600; }
        input[type="radio"] { display: none; }
        input[type="radio"]:checked + label { border-color: #4e73df; background: #4e73df; color: white; }
    </style>
</head>
<body>
    <div class="form-card">
        <h2>New Ledger Entry</h2>
        <p>Client: <b><?php echo $client['name']; ?></b></p>
        <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">
        
        <form action="handle_transaction.php" method="POST">
            <input type="hidden" name="client_id" value="<?php echo $client_id; ?>">
            
            <label>Transaction Type</label>
            <div class="type-selector">
                <input type="radio" id="debit" name="transaction_type" value="Debit" checked>
                <label for="debit" class="type-btn">Debit (+) <br><small>I am charging client</small></label>
                
                <input type="radio" id="credit" name="transaction_type" value="Credit">
                <label for="credit" class="type-btn">Credit (-) <br><small>Client paid me</small></label>
            </div>

            <label>Amount (PKR)</label>
            <input type="number" name="amount" placeholder="e.g. 50000" required>
            
            <label>Description / Detail</label>
            <input type="text" name="notes" placeholder="e.g. Service Fee, Ticket Charge, Partial Payment" required>
            
            <label>Date</label>
            <input type="date" name="p_date" value="<?php echo date('Y-m-d'); ?>" required>
            
            <button type="submit" class="btn">Save Transaction</button>
        </form>
    </div>
</body>
</html>