<?php 
include 'config.php'; 
if(!isset($_SESSION['user_role']) || $_SESSION['user_role'] != 'SuperAdmin') {
    header("Location: dashboard.php"); exit();
}

// --- HANDLE DELETE LOGIC ---
if(isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    // Because we added ON DELETE CASCADE in SQL, this will now work perfectly!
    if($conn->query("DELETE FROM group_tickets WHERE id = $id")) {
        header("Location: admin_group_tickets.php?msg=deleted");
        exit();
    }
}

// Fetch Data for the page
$airline_list = $conn->query("SELECT * FROM airlines ORDER BY name ASC");
$groups = $conn->query("SELECT g.*, a.name as airline_name, a.logo_path 
                        FROM group_tickets g 
                        JOIN airlines a ON g.airline_id = a.id 
                        ORDER BY g.id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>B2B Group Inventory | Super Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --success: #1cc88a; --danger: #e74a3b; --bg: #f8f9fc; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); padding: 40px; }
        .card { background: #fff; padding: 30px; border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); margin-bottom: 30px; }
        
        .form-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px; }
        label { display: block; font-size: 12px; font-weight: 600; color: #64748b; margin-bottom: 5px; text-transform: uppercase; }
        input, select { width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 10px; font-size: 14px; }
        
        .btn { padding: 12px 25px; border-radius: 10px; border: none; cursor: pointer; font-weight: 600; text-decoration: none; transition: 0.3s; }
        .btn-primary { background: var(--primary); color: white; }
        .btn-success { background: var(--success); color: white; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th { text-align: left; padding: 15px; background: #f8f9fc; color: #64748b; font-size: 11px; text-transform: uppercase; }
        td { padding: 15px; border-bottom: 1px solid #f1f5f9; font-size: 14px; }
        .airline-img { height: 30px; vertical-align: middle; margin-right: 10px; }
        .badge { padding: 4px 10px; border-radius: 50px; font-size: 10px; font-weight: 700; }
    </style>
</head>
<body>

    <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:30px;">
        <h1><i class="fas fa-plane-departure" style="color:var(--primary);"></i> B2B Group Inventory</h1>
        <a href="admin_dashboard.php" style="color: #64748b; text-decoration:none;"><i class="fas fa-arrow-left"></i> Dashboard</a>
    </div>

    <!-- POST NEW DEAL -->
    <div class="card">
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:20px;">
            <h3>Post New Ticket Group</h3>
            <a href="manage_airlines.php" class="btn btn-success" style="font-size:12px;"><i class="fas fa-plus"></i> Add Airline Logo</a>
        </div>
        
        <form action="handle_group_tickets.php" method="POST">
            <div class="form-grid">
                <div>
                    <label>Airline</label>
                    <select name="airline_id" required>
                        <option value="">-- Select --</option>
                        <?php while($a = $airline_list->fetch_assoc()): ?>
                            <option value="<?php echo $a['id']; ?>"><?php echo $a['name']; ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div>
                    <label>Trip Type</label>
                    <select name="trip_type" id="trip_type" onchange="toggleReturn()">
                        <option value="One Way">One Way</option>
                        <option value="Return">Return (Round Trip)</option>
                    </select>
                </div>
                <div>
                    <label>Dep. Date</label>
                    <input type="date" name="travel_date" required>
                </div>
                <div id="ret_date_box" style="display:none;">
                    <label>Ret. Date</label>
                    <input type="date" name="return_date">
                </div>
            </div>

            <div class="form-grid">
                <div>
                    <label>Sector / Route</label>
                    <input type="text" name="route" placeholder="e.g. LHE-JED-LHE" required>
                </div>
                <div>
                    <label>Price per Seat</label>
                    <input type="number" name="price" placeholder="Amount in PKR" required>
                </div>
                <div>
                    <label>Total Seats</label>
                    <input type="number" name="seats" placeholder="Inventory Count" required>
                </div>
            </div>

            <div class="form-grid">
                <div>
                    <label>Departure Baggage</label>
                    <input type="text" name="dep_baggage" placeholder="e.g. 30KG + 7KG" required>
                </div>
                <div id="ret_bag_box" style="display:none;">
                    <label>Return Baggage</label>
                    <input type="text" name="ret_baggage" placeholder="e.g. 30KG">
                </div>
            </div>

            <button type="submit" name="add_group" class="btn btn-primary" style="width:100%;">Post Deal to All Agencies</button>
        </form>
    </div>

    <!-- LIVE GROUPS TABLE -->
    <div class="card">
        <h3>Live Deals</h3>
        <table>
            <thead>
                <tr>
                    <th>Airline</th>
                    <th>Route</th>
                    <th>Dates</th>
                    <th>Seats</th>
                    <th>Price</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $groups->fetch_assoc()): ?>
                <tr>
                    <td>
                        <img src="<?php echo $row['logo_path']; ?>" class="airline-img">
                        <b><?php echo $row['airline_name']; ?></b><br>
                        <span class="badge" style="background:#e0e7ff; color:#4338ca;"><?php echo $row['trip_type']; ?></span>
                    </td>
                    <td><b><?php echo $row['route']; ?></b></td>
                    <td>
                        <small>DEP: <?php echo date('d M Y', strtotime($row['travel_date'])); ?></small>
                        <?php if($row['trip_type'] == 'Return'): ?>
                            <br><small>RET: <?php echo date('d M Y', strtotime($row['return_date'])); ?></small>
                        <?php endif; ?>
                    </td>
                    <td><b style="color:var(--primary);"><?php echo $row['available_seats']; ?></b> / <?php echo $row['total_seats']; ?></td>
                    <td style="color:var(--success); font-weight:700;">PKR <?php echo number_format($row['price_per_seat']); ?></td>
                    <td>
                        <a href="view_group_requests.php?id=<?php echo $row['id']; ?>" class="btn" style="background:#f1f5f9; color:var(--primary); font-size:12px;"><i class="fas fa-users"></i> Requests</a>
                        <a href="?delete=<?php echo $row['id']; ?>" class="btn" style="background:#fee2e2; color:var(--danger); font-size:12px;" onclick="return confirm('Delete deal and all booking requests?')"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <script>
        function toggleReturn() {
            var type = document.getElementById('trip_type').value;
            document.getElementById('ret_date_box').style.display = (type == 'Return') ? 'block' : 'none';
            document.getElementById('ret_bag_box').style.display = (type == 'Return') ? 'block' : 'none';
        }
    </script>
</body>
</html>