<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$agency_id = $_SESSION['agency_id'];

// Fetch clients only for this specific agency
$clients = $conn->query("SELECT * FROM clients WHERE agency_id = $agency_id ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Clients | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg-color: #f8f9fc; --sidebar-width: 260px; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg-color); display: flex; }
        
        .sidebar { width: var(--sidebar-width); background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 8px; margin: 5px 20px; }
        .nav-link:hover, .active { background: rgba(255,255,255,0.1); color: #fff; }

        .main-content { margin-left: var(--sidebar-width); width: calc(100% - var(--sidebar-width)); padding: 40px; }
        
        .card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.02); margin-bottom: 30px; }
        .form-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; }
        input, select, textarea { width: 100%; padding: 12px; margin-top: 5px; border: 1px solid #ddd; border-radius: 8px; }
        label { font-size: 13px; font-weight: 500; color: #64748b; }
        
        .btn { background: var(--primary); color: #fff; padding: 12px 25px; border: none; border-radius: 8px; cursor: pointer; font-weight: 500; margin-top: 20px; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th { text-align: left; padding: 15px; background: #f1f5f9; color: #64748b; font-size: 13px; text-transform: uppercase; }
        td { padding: 15px; border-bottom: 1px solid #f1f5f9; font-size: 14px; }
        
        .passport-tag { background: #e0e7ff; color: #4338ca; padding: 2px 8px; border-radius: 4px; font-size: 12px; font-weight: 600; }
        .expiry-alert { color: #dc2626; font-weight: 600; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div style="padding: 0 25px 30px; font-weight: 600; font-size: 18px;"><i class="fas fa-plane-departure text-primary"></i> TRAVEL SAAS</div>
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <a href="clients.php" class="nav-link active"><i class="fas fa-users"></i> My Clients</a>
        <a href="queries.php" class="nav-link"><i class="fas fa-question-circle"></i> Enquiries</a>
        <a href="marketplace.php" class="nav-link"><i class="fas fa-shopping-cart"></i> B2B Marketplace</a>
        <a href="umrah_vouchers.php" class="nav-link"><i class="fas fa-kaaba"></i> Umrah Vouchers</a>
        <a href="ticket_vouchers.php" class="nav-link "><i class="fas fa-ticket-alt"></i> Ticket Vouchers</a>
        <a href="posters.php" class="nav-link"><i class="fas fa-image"></i> Poster Maker</a>
        <a href="ledger.php" class="nav-link"><i class="fas fa-wallet"></i> My Accounts</a>
        <?php if($_SESSION['user_role'] == 'AgencyOwner'): ?>
            <a href="staff.php" class="nav-link"><i class="fas fa-user-tie"></i> Manage Staff</a>
            <a href="agency_profile.php" class="nav-link"><i class="fas fa-cog"></i> Settings</a>
        <?php endif; ?>
        <div style="position: absolute; bottom: 20px; width: 100%;">
            <a href="logout.php" class="nav-link" style="color: #ff7675;"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
    </div>


    <div class="main-content">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
            <h1>Client Database</h1>
            <button onclick="document.getElementById('addClientForm').scrollIntoView();" class="btn"><i class="fas fa-plus"></i> Add New Client</button>
        </div>

        <!-- Client List Table -->
        <div class="card">
            <h3>Registered Clients</h3>
            <table>
                <thead>
                    <tr>
                        <th>Client Name</th>
                        <th>Contact info</th>
                        <th>Passport No.</th>
                        <th>Passport Expiry</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $clients->fetch_assoc()): 
                        // Expiry logic: If passport expires in less than 6 months (Standard for Umrah)
                        $expiry_ts = strtotime($row['passport_expiry']);
                        $six_months_away = strtotime('+6 months');
                        $is_expiring = ($expiry_ts < $six_months_away);
                    ?>
                    <tr>
                        <td><b><?php echo $row['name']; ?></b><br><small><?php echo $row['city']; ?></small></td>
                        <td><?php echo $row['phone_number']; ?><br><small><?php echo $row['email']; ?></small></td>
                        <td><span class="passport-tag"><?php echo $row['passport_no'] ? $row['passport_no'] : 'N/A'; ?></span></td>
                        <td class="<?php echo $is_expiring ? 'expiry-alert' : ''; ?>">
                            <?php echo $row['passport_expiry'] != '0000-00-00' ? date('M d, Y', $expiry_ts) : 'N/A'; ?>
                            <?php if($is_expiring && $row['passport_expiry'] != '0000-00-00') echo '<br><small><i class="fas fa-exclamation-triangle"></i> Renew Soon</small>'; ?>
                        </td>
                        <td>
                            <a href="view_client.php?id=<?php echo $row['id']; ?>" title="View Details"><i class="fas fa-eye" style="color: var(--primary);"></i></a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- Add Client Form -->
        <div class="card" id="addClientForm">
            <h3><i class="fas fa-user-plus"></i> Add New Client Information</h3>
            <form action="handle_client.php" method="POST">
                <div class="form-grid">
                    <div>
                        <label>Full Name</label>
                        <input type="text" name="name" placeholder="Enter name" required>
                    </div>
                    <div>
                        <label>Phone Number</label>
                        <input type="text" name="phone_number" placeholder="03XXXXXXXXX" required>
                    </div>
                    <div>
                        <label>Email (Optional)</label>
                        <input type="email" name="email" placeholder="client@email.com">
                    </div>
                    <div>
                        <label>Passport Number</label>
                        <input type="text" name="passport_no" placeholder="e.g. AB123456">
                    </div>
                    <div>
                        <label>Passport Expiry</label>
                        <input type="date" name="passport_expiry">
                    </div>
                    <div>
                        <label>City</label>
                        <input type="text" name="city" placeholder="e.g. Sargodha">
                    </div>
                </div>
                <div style="margin-top: 15px;">
                    <label>Full Address</label>
                    <textarea name="address" rows="2" placeholder="Home address..."></textarea>
                </div>
                <button type="submit" name="add_client" class="btn">Save Client to Database</button>
            </form>
        </div>
    </div>

</body>
</html>