<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$agency_id = $_SESSION['agency_id'];
$client_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// 1. Fetch Existing Client Data (Security check: must belong to logged-in agency)
$stmt = $conn->prepare("SELECT * FROM clients WHERE id = ? AND agency_id = ?");
$stmt->bind_param("ii", $client_id, $agency_id);
$stmt->execute();
$client = $stmt->get_result()->fetch_assoc();

if(!$client) {
    die("Error: Client record not found or you do not have permission to edit it.");
}

// 2. Handle Form Submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $phone = $_POST['phone_number'];
    $email = $_POST['email'];
    $passport = $_POST['passport_no'];
    $expiry = $_POST['passport_expiry'];
    $city = $_POST['city'];
    $address = $_POST['address'];

    $update_stmt = $conn->prepare("UPDATE clients SET name=?, phone_number=?, email=?, passport_no=?, passport_expiry=?, city=?, address=? WHERE id=? AND agency_id=?");
    $update_stmt->bind_param("sssssssii", $name, $phone, $email, $passport, $expiry, $city, $address, $client_id, $agency_id);

    if ($update_stmt->execute()) {
        header("Location: view_client.php?id=$client_id&msg=updated");
        exit();
    } else {
        $error = "Update failed: " . $conn->error;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Client | <?php echo $client['name']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --bg: #f8f9fc; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); padding: 40px; }
        .container { max-width: 900px; margin: auto; }
        
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
        .btn-back { text-decoration: none; color: #64748b; font-weight: 600; font-size: 14px; }
        
        .card { background: #fff; padding: 35px; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); }
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .form-group { margin-bottom: 20px; }
        
        label { display: block; font-size: 12px; font-weight: 600; color: #64748b; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 0.5px; }
        input, select, textarea { width: 100%; padding: 12px; border: 1px solid #e2e8f0; border-radius: 12px; font-size: 14px; outline: none; transition: 0.3s; }
        input:focus, textarea:focus { border-color: var(--primary); box-shadow: 0 0 0 4px rgba(78, 115, 223, 0.1); }
        
        .btn-save { background: var(--primary); color: white; border: none; padding: 15px 40px; border-radius: 12px; font-weight: 700; font-size: 16px; cursor: pointer; width: 100%; margin-top: 20px; transition: 0.3s; box-shadow: 0 4px 12px rgba(78, 115, 223, 0.2); }
        .btn-save:hover { transform: translateY(-2px); opacity: 0.9; }
        
        .section-title { font-size: 14px; color: var(--primary); font-weight: 700; margin-bottom: 20px; display: flex; align-items: center; gap: 10px; }
        .section-title hr { flex: 1; border: 0; border-top: 1px solid #eee; }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <div>
            <a href="view_client.php?id=<?php echo $client_id; ?>" class="btn-back"><i class="fas fa-arrow-left"></i> Back to Profile</a>
            <h1 style="margin-top: 10px;">Edit Client Profile</h1>
        </div>
    </div>

    <?php if(isset($error)) echo "<p style='color:red; margin-bottom:15px;'>$error</p>"; ?>

    <div class="card">
        <form action="" method="POST">
            
            <div class="section-title"><i class="fas fa-user"></i> Personal Information <hr></div>
            
            <div class="form-grid">
                <div class="form-group">
                    <label>Full Name</label>
                    <input type="text" name="name" value="<?php echo htmlspecialchars($client['name']); ?>" required>
                </div>
                <div class="form-group">
                    <label>Phone Number</label>
                    <input type="text" name="phone_number" value="<?php echo htmlspecialchars($client['phone_number']); ?>" required>
                </div>
                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" name="email" value="<?php echo htmlspecialchars($client['email']); ?>">
                </div>
                <div class="form-group">
                    <label>City</label>
                    <input type="text" name="city" value="<?php echo htmlspecialchars($client['city']); ?>">
                </div>
            </div>

            <div class="form-group">
                <label>Home/Office Address</label>
                <textarea name="address" rows="2"><?php echo htmlspecialchars($client['address']); ?></textarea>
            </div>

            <div class="section-title" style="margin-top: 20px;"><i class="fas fa-passport"></i> Travel Documents <hr></div>

            <div class="form-grid">
                <div class="form-group">
                    <label>Passport Number</label>
                    <input type="text" name="passport_no" value="<?php echo htmlspecialchars($client['passport_no']); ?>">
                </div>
                <div class="form-group">
                    <label>Passport Expiry Date</label>
                    <input type="date" name="passport_expiry" value="<?php echo $client['passport_expiry']; ?>">
                </div>
            </div>

            <button type="submit" class="btn-save">Update Client Record</button>
        </form>
    </div>
</div>

</body>
</html>