<?php 
include 'config.php'; 
if($_SESSION['user_role'] != 'SuperAdmin') exit();

$agencies = $conn->query("SELECT id, agency_name FROM agencies WHERE id > 1");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Generate Invoice | Super Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background: #f8f9fc; padding: 50px; }
        .form-card { background: #fff; max-width: 500px; margin: auto; padding: 30px; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); }
        input, select, textarea { width: 100%; padding: 12px; margin: 10px 0; border: 1px solid #ddd; border-radius: 8px; box-sizing: border-box; }
        .btn { background: #4e73df; color: white; padding: 15px; border: none; width: 100%; border-radius: 8px; font-weight: 600; cursor: pointer; }
    </style>
</head>
<body>
    <div class="form-card">
        <h2><i class="fas fa-file-invoice"></i> Create Agency Bill</h2>
        <form action="handle_generate_invoice.php" method="POST">
            <label>Select Agency</label>
            <select name="agency_id" required>
                <?php while($row = $agencies->fetch_assoc()) echo "<option value='".$row['id']."'>".$row['agency_name']."</option>"; ?>
            </select>

            <label>Description</label>
            <input type="text" name="description" placeholder="e.g. Monthly Subscription - Jan 2026" required>

            <label>Amount (PKR)</label>
            <input type="number" name="amount" placeholder="5000" required>

            <label>Due Date</label>
            <input type="date" name="due_date" value="<?php echo date('Y-m-d', strtotime('+7 days')); ?>">

            <button type="submit" class="btn">Generate & Send Invoice</button>
        </form>
    </div>
</body>
</html>