<?php include 'config.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Travel Agency OS</title>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #4e73df;
            --primary-dark: #224abe;
            --secondary: #1e293b;
            --text-main: #334155;
            --bg-gradient: linear-gradient(135deg, #f8f9fc 0%, #e2e8f0 100%);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Inter', sans-serif; }

        body {
            background: var(--bg-gradient);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        /* Background Shapes for Tech Feel */
        .shape { position: absolute; z-index: -1; filter: blur(80px); opacity: 0.4; }
        .shape-1 { top: -10%; left: -10%; width: 400px; height: 400px; background: #4e73df; border-radius: 50%; }
        .shape-2 { bottom: -10%; right: -10%; width: 350px; height: 350px; background: #1cc88a; border-radius: 50%; }

        .login-card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            width: 420px;
            padding: 50px 40px;
            border-radius: 24px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.5);
            text-align: center;
            animation: slideUp 0.6s ease-out;
        }

        @keyframes slideUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .logo-area { margin-bottom: 35px; }
        .logo-icon {
            width: 60px; height: 60px; background: var(--primary);
            color: white; font-size: 28px; display: inline-flex;
            align-items: center; justify-content: center;
            border-radius: 16px; margin-bottom: 15px;
            box-shadow: 0 10px 20px rgba(78, 115, 223, 0.3);
        }

        .logo-area h2 { font-size: 24px; font-weight: 700; color: var(--secondary); letter-spacing: -0.5px; }
        .logo-area p { font-size: 14px; color: #64748b; margin-top: 5px; }

        /* Form Styling */
        .form-group { position: relative; margin-bottom: 20px; text-align: left; }
        .form-group i { position: absolute; left: 15px; top: 42px; color: #94a3b8; font-size: 16px; }
        
        label { font-size: 12px; font-weight: 600; color: #475569; text-transform: uppercase; letter-spacing: 0.5px; margin-left: 5px; }
        input {
            width: 100%; padding: 12px 15px 12px 45px; margin-top: 8px;
            border: 1.5px solid #e2e8f0; border-radius: 12px;
            font-size: 15px; background: white; transition: all 0.3s;
            color: var(--secondary);
        }
        input:focus { border-color: var(--primary); box-shadow: 0 0 0 4px rgba(78, 115, 223, 0.1); outline: none; }

        .btn-login {
            width: 100%; padding: 14px; background: var(--primary);
            color: white; border: none; border-radius: 12px;
            font-size: 16px; font-weight: 600; cursor: pointer;
            transition: all 0.3s; margin-top: 10px;
            box-shadow: 0 4px 12px rgba(78, 115, 223, 0.2);
        }
        .btn-login:hover { background: var(--primary-dark); transform: translateY(-1px); box-shadow: 0 8px 15px rgba(78, 115, 223, 0.3); }

        .error-msg {
            background: #fff1f2; color: #be123c; padding: 12px;
            border-radius: 10px; font-size: 13px; font-weight: 500;
            margin-bottom: 20px; border: 1px solid #fecdd3;
        }

        .footer-branding { margin-top: 40px; border-top: 1px solid #e2e8f0; padding-top: 20px; }
        .footer-branding p { font-size: 11px; color: #94a3b8; text-transform: uppercase; letter-spacing: 1px; }
        .footer-branding b { color: #64748b; }

    </style>
</head>
<body>

    <div class="shape shape-1"></div>
    <div class="shape shape-2"></div>

    <div class="login-card">
        <div class="logo-area">
            <div class="logo-icon">
                <i class="fas fa-paper-plane"></i>
            </div>
            <h2>Travel SaaS <span style="color:var(--primary)">OS</span></h2>
            <p>Cloud-based Enterprise Management</p>
        </div>

        <?php if(isset($_GET['error'])): ?>
            <div class="error-msg">
                <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($_GET['error']); ?>
            </div>
        <?php endif; ?>

        <form action="login_action.php" method="POST">
            <div class="form-group">
                <label>Access Email</label>
                <i class="fas fa-envelope"></i>
                <input type="email" name="email" placeholder="name@company.com" required>
            </div>

            <div class="form-group">
                <label>Security Key</label>
                <i class="fas fa-lock"></i>
                <input type="password" name="password" placeholder="••••••••" required>
            </div>

            <button type="submit" class="btn-login">
                Sign In to System <i class="fas fa-arrow-right" style="margin-left:8px; font-size:12px;"></i>
            </button>
        </form>

        <div class="footer-branding">
            <p>A Product of <b>TZ Tech Solutions</b></p>
        </div>
    </div>

</body>
</html>