<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$aid = $_SESSION['agency_id'];
$agency_data = $conn->query("SELECT balance_due, agency_name FROM agencies WHERE id = $aid")->fetch_assoc();
$bal = $agency_data['balance_due'];

// If they accidentally land here with 0 balance, send them back
if($bal <= 0) { header("Location: dashboard.php"); exit(); }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payment Instructions | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --success: #1cc88a; --danger: #e74a3b; --dark: #1e293b; --bg: #f8f9fc; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); padding: 40px; color: #444; }
        .container { max-width: 800px; margin: auto; }
        
        /* Summary Card */
        .balance-card { 
            background: linear-gradient(135deg, #e74a3b 0%, #be281a 100%); 
            color: white; padding: 40px; border-radius: 20px; text-align: center; 
            box-shadow: 0 10px 25px rgba(231, 74, 59, 0.3); margin-bottom: 30px;
        }
        .balance-card h1 { font-size: 42px; margin: 10px 0; }
        .balance-card p { opacity: 0.9; font-size: 14px; text-transform: uppercase; letter-spacing: 1px; }

        /* Payment Methods */
        .methods-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .method-card { 
            background: white; padding: 25px; border-radius: 15px; 
            box-shadow: 0 4px 15px rgba(0,0,0,0.02); border: 1px solid #e2e8f0;
            transition: 0.3s;
        }
        .method-card:hover { transform: translateY(-5px); box-shadow: 0 10px 25px rgba(0,0,0,0.05); }
        .method-icon { width: 50px; height: 50px; border-radius: 10px; display: flex; align-items: center; justify-content: center; margin-bottom: 15px; font-size: 20px; }
        
        .bank-icon { background: #e0e7ff; color: #4e73df; }
        .mobile-icon { background: #fff3cd; color: #856404; }

        .method-card h3 { font-size: 16px; margin-bottom: 10px; color: var(--dark); }
        .method-card p { font-size: 13px; color: #64748b; line-height: 1.8; margin-bottom: 5px; }
        .method-card b { color: #333; }

        .instruction-box { 
            background: #fff; padding: 25px; border-radius: 15px; margin-top: 30px; 
            border-left: 5px solid var(--primary); font-size: 14px; color: #475569;
        }
        
        .btn-back { 
            display: inline-block; margin-top: 30px; text-decoration: none; 
            color: #64748b; font-weight: 600; font-size: 14px; transition: 0.3s;
        }
        .btn-back:hover { color: var(--primary); }

        .copy-hint { font-size: 10px; background: #f1f5f9; padding: 2px 6px; border-radius: 4px; margin-left: 5px; cursor: pointer; }
    </style>
</head>
<body>

<div class="container">
    <a href="dashboard.php" class="btn-back"><i class="fas fa-arrow-left"></i> Back to Dashboard</a>

    <div class="balance-card">
        <p>Current Outstanding Amount</p>
        <h1>PKR <?php echo number_format($bal); ?></h1>
        <small>Agency: <?php echo $agency_data['agency_name']; ?></small>
    </div>

    <h2 style="margin-bottom: 20px; font-size: 20px;">Choose Payment Method</h2>
    
    <div class="methods-grid">
        <!-- Bank Account -->
        <div class="method-card">
            <div class="method-icon bank-icon"><i class="fas fa-university"></i></div>
            <h3>Bank Transfer</h3>
            <p>Bank: <b>Meezan Bank Ltd</b></p>
            <p>Title: <b>Muhammad Ahmad Daud</b></p>
            <p>Account: <b>14020111921055</b></p>
            <p>IBAN: <b>PK04MEZN0014020111921055</b></p>
        </div>

        <!-- JazzCash / EasyPaisa -->
        <div class="method-card">
            <div class="method-icon mobile-icon"><i class="fas fa-mobile-alt"></i></div>
            <h3>Mobile Wallets</h3>
            <p>JazzCash: <b>0309-8241902</b></p>
            <p>Account Title: <b>Muhammad Ahmad Daud</b></p>
        </div>
    </div>

    <div class="instruction-box">
        <h4 style="color: var(--primary); margin-bottom: 10px;"><i class="fas fa-info-circle"></i> What to do after paying?</h4>
        <p>1. Take a screenshot or photo of your payment receipt.</p>
        <p>2. Send the receipt to our WhatsApp: <b>+92 309 8241902</b></p>
        <p>3. Mention your Agency ID: <b>#AG-<?php echo str_pad($aid, 4, '0', STR_PAD_LEFT); ?></b></p>
        <p style="margin-top: 10px; font-weight: 600;">Your account balance will be updated within 1-2 hours of verification.</p>
    </div>

    <div style="text-align: center; margin-top: 40px;">
        <p style="font-size: 12px; color: #94a3b8;">Having trouble? Email us at tztravelandtours2@gmail.com</p>
    </div>
</div>

</body>
</html>