<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$agency_id = $_SESSION['agency_id'];
// Path to the file generated by the oneway or return generator
$file = 'generated_posters/poster_'.$agency_id.'.html';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Preview & Download Poster | Travel SaaS</title>
    <!-- Modern Font & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- html2canvas for high quality images -->
    <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
    
    <style>
        body { background: #d1d9e6; margin: 0; padding: 40px 0; font-family: 'Poppins', sans-serif; }
        
        /* Floating Toolbar */
        .toolbar { 
            max-width: 1080px; margin: 0 auto 30px; display: flex; justify-content: space-between; align-items: center; 
            background: rgba(255, 255, 255, 0.9); padding: 15px 25px; border-radius: 15px; 
            box-shadow: 0 10px 30px rgba(0,0,0,0.1); backdrop-filter: blur(10px);
        }
        
        .btn { 
            padding: 12px 25px; border-radius: 10px; border: none; cursor: pointer; 
            font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 8px; transition: 0.3s; 
        }
        .btn-back { background: #fff; color: #1e293b; border: 1px solid #e2e8f0; }
        .btn-download { background: #1cc88a; color: #fff; box-shadow: 0 4px 15px rgba(28, 200, 138, 0.3); }
        .btn:hover { transform: translateY(-2px); opacity: 0.9; }

        /* Poster Display Area */
        #poster-wrap { 
            width: fit-content; margin: auto; border-radius: 5px; overflow: hidden; 
            box-shadow: 0 30px 70px rgba(0,0,0,0.2); background: white; 
        }

        /* Instructions */
        .hint { text-align: center; color: #475569; font-size: 13px; margin-top: 20px; }

        @media print { .toolbar { display: none; } }
    </style>
</head>
<body>

    <div class="toolbar">
        <div>
            <a href="posters.php" class="btn btn-back">
                <i class="fas fa-arrow-left"></i> Back to Studio
            </a>
        </div>
        <div style="text-align:center;">
            <b style="color: #1e293b;">Live Preview</b><br>
            <small style="color: #64748b;">Ready for Social Media</small>
        </div>
        <div>
            <button class="btn btn-download" onclick="downloadPoster()">
                <i class="fas fa-cloud-download-alt"></i> Save as High-Res Image
            </button>
        </div>
    </div>

    <div id="poster-wrap">
        <?php 
        if(file_exists($file)) {
            include $file; 
        } else {
            echo "<div style='padding:100px; text-align:center; background:white;'>
                    <i class='fas fa-exclamation-triangle' style='font-size:50px; color:#f6c23e;'></i>
                    <h3>Poster File Not Found</h3>
                    <p>Please go back and click 'Generate' again.</p>
                  </div>";
        }
        ?>
    </div>

    <p class="hint"><i class="fas fa-info-circle"></i> This image is optimized for WhatsApp Status (1080x1350px).</p>

    <script>
        function downloadPoster() {
            const el = document.getElementById('poster-content');
            const btn = document.querySelector('.btn-download');
            
            // UI Feedback
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
            btn.style.opacity = "0.7";

            html2canvas(el, { 
                scale: 4, // Scale 4 ensures crystal clear text on mobile screens
                useCORS: true,
                allowTaint: true,
                backgroundColor: "#ffffff",
                logging: false
            }).then(canvas => {
                // 1. Trigger the hidden usage logger
                fetch('log_poster.php');
                
                // 2. Trigger the Download
                const link = document.createElement('a');
                link.download = 'Travel-Ad-<?php echo date("Ymd_His"); ?>.png';
                link.href = canvas.toDataURL('image/png', 1.0);
                link.click();

                // 3. Reset Button
                btn.innerHTML = '<i class="fas fa-check"></i> Downloaded';
                btn.style.background = "#4e73df";
                setTimeout(() => {
                    btn.innerHTML = '<i class="fas fa-cloud-download-alt"></i> Save as High-Res Image';
                    btn.style.background = "#1cc88a";
                    btn.style.opacity = "1";
                }, 3000);
            });
        }
    </script>
</body>
</html>