<?php 
include 'config.php'; 
if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
$agency_id = $_SESSION['agency_id'];

// Fetch Usage Limits
$usage = $conn->query("SELECT posters_generated, max_posters FROM agencies WHERE id = $agency_id")->fetch_assoc();
$left = $usage['max_posters'] - $usage['posters_generated'];
$percentage = ($usage['posters_generated'] / $usage['max_posters']) * 100;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Poster Studio | Travel SaaS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root { --primary: #4e73df; --secondary: #1e293b; --success: #1cc88a; --bg: #f8f9fc; --sidebar-width: 260px; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); display: flex; }
        
        /* Sidebar Styling */
        .sidebar { width: var(--sidebar-width); background: var(--secondary); height: 100vh; position: fixed; color: #fff; padding: 20px 0; z-index: 100; }
        .nav-link { display: flex; align-items: center; padding: 12px 15px; color: rgba(255,255,255,0.7); text-decoration: none; border-radius: 10px; margin: 5px 20px; transition: 0.3s; }
        .nav-link:hover, .active { background: rgba(255,255,255,0.1); color: #fff; }
        .nav-link i { width: 30px; font-size: 18px; }

        .main-content { margin-left: var(--sidebar-width); width: calc(100% - var(--sidebar-width)); padding: 60px; }
        
        .header-area { display: flex; justify-content: space-between; align-items: flex-end; margin-bottom: 40px; }
        h1 { font-size: 32px; font-weight: 700; color: var(--secondary); letter-spacing: -1px; }
        
        /* Usage Tracker Pill */
        .limit-pill { background: white; padding: 15px 25px; border-radius: 15px; box-shadow: 0 10px 25px rgba(0,0,0,0.05); width: 280px; }
        .limit-bar { height: 6px; background: #e2e8f0; border-radius: 10px; margin-top: 10px; overflow: hidden; }
        .limit-progress { height: 100%; background: var(--primary); transition: 0.5s; }

        /* Grid System */
        .studio-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 30px; }
        
        .option-card { 
            background: white; border-radius: 24px; padding: 40px; text-align: center; 
            text-decoration: none; color: inherit; transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            border: 1px solid #edf2f7; box-shadow: 0 15px 35px rgba(0,0,0,0.03);
            display: flex; flex-direction: column; align-items: center; justify-content: center;
            position: relative; overflow: hidden;
        }

        /* Hover Effects */
        .option-card:hover { transform: translateY(-12px); box-shadow: 0 25px 50px rgba(0,0,0,0.08); border-color: var(--primary); }
        .option-card::before { content: ""; position: absolute; top: 0; left: 0; width: 100%; height: 8px; background: var(--primary); opacity: 0; transition: 0.3s; }
        .option-card:hover::before { opacity: 1; }

        .icon-box { 
            width: 90px; height: 90px; border-radius: 20px; 
            background: rgba(78, 115, 223, 0.08); color: var(--primary);
            display: flex; align-items: center; justify-content: center;
            font-size: 36px; margin-bottom: 25px; transition: 0.3s;
        }
        .option-card:hover .icon-box { background: var(--primary); color: white; transform: rotate(-5deg); }

        .option-card h3 { font-size: 24px; font-weight: 700; color: var(--secondary); margin-bottom: 12px; }
        .option-card p { color: #64748b; font-size: 14px; line-height: 1.6; max-width: 250px; }

        .btn-create { 
            margin-top: 30px; padding: 12px 30px; border-radius: 50px; 
            background: #f1f5f9; color: var(--primary); font-weight: 700; 
            font-size: 13px; text-transform: uppercase; letter-spacing: 1px; transition: 0.3s;
        }
        .option-card:hover .btn-create { background: var(--primary); color: white; }

        /* Small labels */
        .tag { position: absolute; top: 20px; right: 20px; background: #fef3c7; color: #92400e; padding: 4px 12px; border-radius: 20px; font-size: 10px; font-weight: 700; text-transform: uppercase; }
    </style>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <div style="padding: 0 25px 30px; font-weight: 600; font-size: 18px;"><i class="fas fa-plane-departure text-primary"></i> TRAVEL SAAS</div>
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <a href="clients.php" class="nav-link "><i class="fas fa-users"></i> My Clients</a>
        <a href="queries.php" class="nav-link "><i class="fas fa-question-circle"></i> Enquiries</a>
        <a href="staff.php" class="nav-link"><i class="fas fa-user-tie"></i> Manage Staff</a>
        <a href="marketplace.php" class="nav-link"><i class="fas fa-shopping-cart"></i> B2B Marketplace</a>
        <a href="umrah_vouchers.php" class="nav-link"><i class="fas fa-kaaba"></i> Umrah Vouchers</a>
        <a href="ticket_vouchers.php" class="nav-link "><i class="fas fa-ticket-alt"></i> Ticket Vouchers</a>
        <a href="posters.php" class="nav-link active"><i class="fas fa-image"></i> Poster Maker</a>
        <a href="ledger.php" class="nav-link"><i class="fas fa-wallet"></i>Clients Account</a>
        <?php if($_SESSION['user_role'] == 'AgencyOwner'): ?>
            
            <a href="agency_profile.php" class="nav-link"><i class="fas fa-cog"></i> Settings</a>
        <?php endif; ?>
        <div style="position: absolute; bottom: 20px; width: 100%;">
            <a href="logout.php" class="nav-link" style="color: #ff7675;"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
    </div>

    <div class="main-content">
        <div class="header-area">
            <div>
                <h1>Poster Designer Studio</h1>
                <p style="color: #64748b;">Choose a layout style to create your marketing ad.</p>
            </div>
            
            <!-- Sleek Usage Tracker -->
            <div class="limit-pill">
                <div style="display:flex; justify-content: space-between; align-items: center;">
                    <small style="color:#64748b; font-weight:700; font-size:10px;">MONTHLY LIMIT</small>
                    <span style="font-size:12px; font-weight:700; color:var(--primary);"><?php echo $left; ?> Left</span>
                </div>
                <div class="limit-bar">
                    <div class="limit-progress" style="width: <?php echo $percentage; ?>%;"></div>
                </div>
                <p style="font-size: 10px; color: #94a3b8; margin-top: 8px;">Used <?php echo $usage['posters_generated']; ?> of <?php echo $usage['max_posters']; ?> downloads</p>
            </div>
        </div>

        <div class="studio-grid">
            <!-- Option 1 -->
            <a href="poster_oneway_generator.php" class="option-card">
                <span class="tag">Popular</span>
                <div class="icon-box"><i class="fas fa-plane-departure"></i></div>
                <h3>One-Way Fares</h3>
                <p>Perfect for quick single-trip group deals and seasonal offers.</p>
                <div class="btn-create">Start Designing</div>
            </a>

            <!-- Option 2 -->
            <a href="poster_return_generator.php" class="option-card">
                <div class="icon-box"><i class="fas fa-exchange-alt"></i></div>
                <h3>Return Fares</h3>
                <p>Detailed round-trip layouts with outbound and inbound schedules.</p>
                <div class="btn-create">Start Designing</div>
            </a>
        </div>
        
        <div style="margin-top: 50px; text-align: center; background: #fff; padding: 20px; border-radius: 15px; border: 1px dashed #cbd5e1; color: #64748b; font-size: 13px;">
            <i class="fas fa-info-circle"></i> Tip: Use high-resolution airline logos for better printing results.
        </div>
    </div>

</body>
</html>